<?php

/* -----------------------------------------------------------------
 * 	$Id: product_filter.php 1577 2016-06-01 10:21:20Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

include ('includes/application_top.php');

$smarty = new Smarty;
require (DIR_FS_CATALOG . 'templates/' . CURRENT_TEMPLATE . '/source/boxes.php');
$breadcrumb->add(NAVBAR_TITLE_PRODUCT_FILTER, xtc_href_link(FILENAME_PRODUCT_FILTER, '', 'SSL'));
require (DIR_WS_INCLUDES . 'header.php');
$smarty->caching = false;
$smarty->assign('language', $_SESSION['language']);

if (( isset($_GET['fcat']) && is_numeric($_GET['fcat'])) && (isset($_GET['item']) && is_numeric($_GET['item']))) {
    $module_smarty = new Smarty;
    $module_smarty->assign('tpl_path', 'templates/' . CURRENT_TEMPLATE . '/');
	$fsk_lock = '';
    if ($_SESSION['customers_status']['customers_fsk18_display'] == '0') {
        $fsk_lock = " AND p.products_fsk18 != '1' ";
	}
	$group_check = '';
    if (GROUP_CHECK == 'true') {
        $group_check = " AND p.group_permission_" . (int) $_SESSION['customers_status']['customers_status_id'] . " = 1 ";
	}

    $select_str = "SELECT
                  p.products_id,
                  p.products_price,
                  p.products_model,
                  p.products_quantity,
                  p.products_shippingtime,
                  p.products_fsk18,
                  p.products_image,
                  p.products_weight,
                  p.products_tax_class_id,
                  pd.products_name,
                  pd.products_short_description,
                  pd.products_description ";

    $from_str = "FROM products_to_filter AS p2f, " . TABLE_PRODUCTS . " AS p LEFT JOIN " . TABLE_PRODUCTS_DESCRIPTION . " AS pd ON (p.products_id = pd.products_id) ";

    $where_str = " WHERE p2f.filter_id = '" . (int) $_GET['item'] . "'
    				AND p.products_id = p2f.products_id
    				AND p.products_status = '1' 
    				AND pd.language_id = '" . (int) $_SESSION['languages_id'] . "'" . $fsk_lock . $group_check . " GROUP BY p.products_id ";

    $smarty->caching = false;
    $smarty->assign('language', $_SESSION['language']);

    $select_item = xtc_db_fetch_array(xtc_db_query("SELECT fi_i.title AS item_title, fi_c.titel AS cat_title
								      FROM " . TABLE_PRODUCT_FILTER_ITEMS . " AS fi_i,
								      	" . TABLE_PRODUCT_FILTER_CATEGORIES . " AS fi_c
								      WHERE fi_i.status = 1
								      AND fi_c.status = 1
								      AND fi_i.id = '" . (int) $_GET['item'] . "'
								      AND fi_i.filter_categories_id = '" . (int) $_GET['fcat'] . "'
								      AND fi_c.id = fi_i.filter_categories_id 
								      AND fi_i.language_id = '" . $_SESSION['languages_id'] . "'
								      AND fi_c.language_id = fi_i.language_id
										"));

    $listing_sql = $select_str . $from_str . $where_str;

    if (isset($_GET['per_site']) && !empty($_GET['per_site'])) {
        $per_site = $_GET['per_site'];
    } elseif (isset($_SESSION['per_site'])) {
        $per_site = $_SESSION['per_site'];
    } elseif (!isset($_SESSION['per_site']) || !isset($_GET['per_site'])) {
        $per_site = MAX_DISPLAY_SEARCH_RESULTS;
	}

    $_SESSION['per_site'] = $per_site;
	$list_name = 'product_filter_grid';
    $listing_split = new splitPageResults($listing_sql, (int) $_GET['page'], (int) $_SESSION['per_site'], 'p.products_id');
    $module_content = array();
    $navigation_smarty = new Smarty;
    $page_links = $listing_split->getLinksArray(MAX_DISPLAY_PAGE_LINKS, xtc_get_all_get_params(array('page', 'info', 'x', 'y', 'cPath', 'cat', 'per_site', 'view_as')), TEXT_DISPLAY_NUMBER_OF_PRODUCTS);
    $navigation_smarty->assign('LINKS', $page_links);
    $navigation_smarty->assign('language', $_SESSION['language']);
    $navigation_smarty->assign('tpl_path', 'templates/' . CURRENT_TEMPLATE . '/');
    $navigation = $navigation_smarty->fetch(CURRENT_TEMPLATE . '/module/product_navigation/products_page_navigation.html');

    $listing_query = xtc_db_query($listing_split->sql_query);
    $rows = 0;
    while ($listing = xtc_db_fetch_array($listing_query)) {
        $rows++;
        $module_content[] = $product->buildDataArray($listing, 'thumbnail', $list_name, $rows);
    }

    $link_url = xtc_href_link(FILENAME_PRODUCT_FILTER, xtc_get_all_get_params(array('view_as', 'per_site', 'x', 'y', 'cat', 'cPath')));

    $module_smarty->assign('products_listing_url', $link_url);

    if ($name != '') {
        $module_smarty->assign('filter_request', $namen);
	}

    $module_smarty->assign('language', $_SESSION['language']);

    if (!empty($module_content)) {
        $module_smarty->assign('module_content', $module_content);
        $module_smarty->assign('CATEGORIES_DESCRIPTION', 'Das passende Produkt ist nicht dabei? Versuchen Sie unseren <a rel="nofollow" href="' . xtc_href_link('product_filter.php', 'advanced_filter=' . $_GET['category']) . '">erweiterten Filter</a>.');
        $module_smarty->assign('CATEGORIES_HEADING_TITLE', 'Alle Treffer f&uuml;r <em>' . $select_item['item_title'] . '</em> aus der Kategorie <em>' . $select_item['cat_title'] . '</em>');
        $module_smarty->assign('NAVIGATION', $navigation);
    } else {
        $module_smarty->assign('CATEGORIES_HEADING_TITLE', 'F&uuml;r <em>' . $select_item['item_title'] . '</em> wurde kein Produkt gefunden / zugewiesen.');
	}

    $module_smarty->caching = false;
    $main_content = $module_smarty->fetch(CURRENT_TEMPLATE . '/module/product_listing/product_listings.html');
	
	
} elseif (isset($_GET['advanced_filter'])) {
    $filter_array = array();
    $cat_count = xtc_db_query("SELECT id, titel, categories_ids FROM " . TABLE_PRODUCT_FILTER_CATEGORIES . " WHERE language_id = '" . $_SESSION['languages_id'] . "' AND status = '1'");
    $count = xtc_db_num_rows($cat_count);
    while ($cat_data = xtc_db_fetch_array($cat_count)) {
        $checkID = explode('|', $cat_data['categories_ids']);
        if (in_array($_GET['advanced_filter'], $checkID) || $cat_data['categories_ids'] == 'all') {
            $filter_array[$cats] = array('CATEGORIE_ID' => $cat_data['id'],
                'CATEGORIE_TITLE' => $cat_data['titel'],
                'ITEMS' => '');

            $filter_query = xtc_db_query("SELECT id, name, filter_categories_id, position
											FROM " . TABLE_PRODUCT_FILTER_ITEMS . "
											WHERE filter_categories_id = '" . $cat_data['id'] . "'
											AND language_id = '" . $_SESSION['languages_id'] . "'
											AND status = '1'
											ORDER BY position ASC
											");

            while ($filter = xtc_db_fetch_array($filter_query)) {
                $filter_array[$cats]['ITEMS'][$item] = array('id' => $filter['id'],
                    'text' => $filter['name'],
                    'checkbox_id' => $filter['id'],
                    'checkbox_checked' => (in_array($filter['id'], $_POST['filter']) ? true : false));
                $item++;
            }
            $cats++;
        }
    }
    $smarty->assign('VERBINDER', xtc_draw_hidden_field('cat', $_GET['advanced_filter']));
    $smarty->assign('filter_search_items', $filter_array);
    $file_name = 'product_filter.php?advanced_filter';
    if (isset($_GET['page']) && $_GET['page'] != '') {
        $page .= '&page=' . $_GET['page'];
	}
    $smarty->assign('FILTER_SEARCH', $_SESSION['filters']);
	if (file_exists('templates/'.CURRENT_TEMPLATE.'/module/product_filter.html')) {
		$main_content = $smarty->fetch(cseo_get_usermod(CURRENT_TEMPLATE.'/module/product_filter.html', USE_TEMPLATE_DEVMODE));
	}else{
		$main_content = $smarty->fetch(cseo_get_usermod('base/module/product_filter.html', USE_TEMPLATE_DEVMODE));
	}
} elseif (!isset($_GET['fcat']) || !isset($_GET['item'])) {
    xtc_redirect(xtc_href_link('product_filter.php', 'advanced_filter'));
}

$smarty->assign('main_content', $main_content);
$smarty->assign('DEVMODE', USE_TEMPLATE_DEVMODE);
$smarty->assign('language', $_SESSION['language']);
$smarty->loadFilter('output', 'note');
$smarty->loadFilter('output', 'trimwhitespace');
$smarty->display(cseo_get_usermod(CURRENT_TEMPLATE . '/index.html', USE_TEMPLATE_DEVMODE));

include ('includes/application_bottom.php');
